using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Borland.Eco.Handles;
using Borland.Eco.Windows.Forms;
using Borland.Eco.WinForm;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;
using FishFactsClasses;

namespace EcoFishFacts
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private Borland.Eco.Handles.ReferenceHandle rhRoot;
		private Borland.Eco.WinForm.EcoActionExtender EcoGlobalActions;
		private Borland.Eco.WinForm.EcoDragDropExtender EcoDragDrop;
		private Borland.Eco.WinForm.EcoAutoFormExtender EcoAutoForms;
		private Borland.Eco.WinForm.EcoListActionExtender EcoListActions;
		private FishFactsEcoSpace m_EcoSpace;
		private Borland.Eco.Handles.ExpressionHandle ehAllBioLife;
		private System.Windows.Forms.DataGrid grdFishes;
		private System.Windows.Forms.PictureBox picFish;
		private System.Windows.Forms.TextBox tbxNotes;
		private System.Windows.Forms.DataGridTableStyle dataGridTableStyle1;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn1;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn2;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn3;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn4;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn5;
		private System.Windows.Forms.DataGridTextBoxColumn dataGridTextBoxColumn6;
		private System.Windows.Forms.Button btnPasteFromClipBoard;
		private System.Windows.Forms.Button btnUpdateDatabase;
		public FishFactsEcoSpace EcoSpace
		{
			get { return m_EcoSpace; }
		}

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			// We need to install conversion routines from the database
			// format (byte array with header data) to the format required
			// by PictureBox (System.Drawing.Image)
			// To accomplish this, we add our own event handlers to the
			// Format and Parse events.
			Binding imageBinding = new Binding("Image", ehAllBioLife, "Image");
			imageBinding.Format += new ConvertEventHandler(this.FormatImage);
			imageBinding.Parse += new ConvertEventHandler(this.ParseImage);
			picFish.DataBindings.Add(imageBinding);


			m_EcoSpace = new FishFactsEcoSpace();
			rhRoot.EcoSpace = m_EcoSpace;
			// The line below will automatically activate the ECO Space on form creation.
			// Remove the line if you wish to activate the EcoSpace manually
			m_EcoSpace.Active = true;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			Borland.Eco.Handles.OclColumn oclColumn11 = new Borland.Eco.Handles.OclColumn();
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			this.EcoListActions = new Borland.Eco.WinForm.EcoListActionExtender();
			this.EcoDragDrop = new Borland.Eco.WinForm.EcoDragDropExtender();
			this.EcoGlobalActions = new Borland.Eco.WinForm.EcoActionExtender();
			this.btnUpdateDatabase = new System.Windows.Forms.Button();
			this.EcoAutoForms = new Borland.Eco.WinForm.EcoAutoFormExtender();
			this.ehAllBioLife = new Borland.Eco.Handles.ExpressionHandle();
			this.grdFishes = new System.Windows.Forms.DataGrid();
			this.dataGridTableStyle1 = new System.Windows.Forms.DataGridTableStyle();
			this.dataGridTextBoxColumn3 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn4 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn1 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn2 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn5 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.dataGridTextBoxColumn6 = new System.Windows.Forms.DataGridTextBoxColumn();
			this.picFish = new System.Windows.Forms.PictureBox();
			this.tbxNotes = new System.Windows.Forms.TextBox();
			this.btnPasteFromClipBoard = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.grdFishes)).BeginInit();
			this.SuspendLayout();
			// 
			// rhRoot
			// 
			this.rhRoot.EcoSpaceType = typeof(EcoFishFacts.FishFactsEcoSpace);
			// 
			// EcoGlobalActions
			// 
			this.EcoGlobalActions.RootHandle = this.rhRoot;
			// 
			// btnUpdateDatabase
			// 
			this.btnUpdateDatabase.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.EcoGlobalActions.SetEcoAction(this.btnUpdateDatabase, Borland.Eco.WinForm.EcoAction.UpdateDatabase);
			this.btnUpdateDatabase.Location = new System.Drawing.Point(8, 440);
			this.btnUpdateDatabase.Name = "btnUpdateDatabase";
			this.btnUpdateDatabase.TabIndex = 4;
			this.btnUpdateDatabase.Text = "Update DB";
			// 
			// ehAllBioLife
			// 
			oclColumn11.Expression = "self.GRAPHIC";
			oclColumn11.IsReadOnly = true;
			oclColumn11.Name = "Image";
			this.ehAllBioLife.Columns.AddRange(new Borland.Eco.Handles.AbstractColumn[] {
						oclColumn11});
			this.ehAllBioLife.Expression = "BioLife.allInstances";
			this.ehAllBioLife.RootHandle = this.rhRoot;
			// 
			// grdFishes
			// 
			this.grdFishes.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.grdFishes.CaptionText = "BioLife.allInstances";
			this.grdFishes.DataMember = "";
			this.grdFishes.DataSource = this.ehAllBioLife;
			this.grdFishes.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.grdFishes.Location = new System.Drawing.Point(8, 8);
			this.grdFishes.Name = "grdFishes";
			this.grdFishes.Size = new System.Drawing.Size(656, 224);
			this.grdFishes.TabIndex = 0;
			this.grdFishes.TableStyles.AddRange(new System.Windows.Forms.DataGridTableStyle[] {
						this.dataGridTableStyle1});
			// 
			// dataGridTableStyle1
			// 
			this.dataGridTableStyle1.DataGrid = this.grdFishes;
			this.dataGridTableStyle1.GridColumnStyles.AddRange(new System.Windows.Forms.DataGridColumnStyle[] {
						this.dataGridTextBoxColumn3,
						this.dataGridTextBoxColumn4,
						this.dataGridTextBoxColumn1,
						this.dataGridTextBoxColumn2,
						this.dataGridTextBoxColumn5,
						this.dataGridTextBoxColumn6});
			this.dataGridTableStyle1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dataGridTableStyle1.MappingName = "";
			// 
			// dataGridTextBoxColumn3
			// 
			this.dataGridTextBoxColumn3.Format = "";
			this.dataGridTextBoxColumn3.FormatInfo = null;
			this.dataGridTextBoxColumn3.HeaderText = "CommonName";
			this.dataGridTextBoxColumn3.MappingName = "CommonName";
			this.dataGridTextBoxColumn3.Width = 130;
			// 
			// dataGridTextBoxColumn4
			// 
			this.dataGridTextBoxColumn4.Format = "";
			this.dataGridTextBoxColumn4.FormatInfo = null;
			this.dataGridTextBoxColumn4.HeaderText = "SpeciesName";
			this.dataGridTextBoxColumn4.MappingName = "SpeciesName";
			this.dataGridTextBoxColumn4.Width = 200;
			// 
			// dataGridTextBoxColumn1
			// 
			this.dataGridTextBoxColumn1.Format = "";
			this.dataGridTextBoxColumn1.FormatInfo = null;
			this.dataGridTextBoxColumn1.HeaderText = "SpeciesNo";
			this.dataGridTextBoxColumn1.MappingName = "SpeciesNo";
			this.dataGridTextBoxColumn1.Width = 75;
			// 
			// dataGridTextBoxColumn2
			// 
			this.dataGridTextBoxColumn2.Format = "";
			this.dataGridTextBoxColumn2.FormatInfo = null;
			this.dataGridTextBoxColumn2.HeaderText = "Category";
			this.dataGridTextBoxColumn2.MappingName = "Category";
			this.dataGridTextBoxColumn2.Width = 75;
			// 
			// dataGridTextBoxColumn5
			// 
			this.dataGridTextBoxColumn5.Format = "";
			this.dataGridTextBoxColumn5.FormatInfo = null;
			this.dataGridTextBoxColumn5.HeaderText = "Cm";
			this.dataGridTextBoxColumn5.MappingName = "LengthInCentimeters";
			this.dataGridTextBoxColumn5.Width = 60;
			// 
			// dataGridTextBoxColumn6
			// 
			this.dataGridTextBoxColumn6.Format = "";
			this.dataGridTextBoxColumn6.FormatInfo = null;
			this.dataGridTextBoxColumn6.HeaderText = "Inches";
			this.dataGridTextBoxColumn6.MappingName = "LengthInInches";
			this.dataGridTextBoxColumn6.Width = 60;
			// 
			// picFish
			// 
			this.picFish.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.picFish.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.picFish.Location = new System.Drawing.Point(384, 240);
			this.picFish.Name = "picFish";
			this.picFish.Size = new System.Drawing.Size(280, 184);
			this.picFish.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picFish.TabIndex = 1;
			this.picFish.TabStop = false;
			// 
			// tbxNotes
			// 
			this.tbxNotes.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left)));
			this.tbxNotes.DataBindings.Add(new System.Windows.Forms.Binding("Text", this.ehAllBioLife, "NOTES"));
			this.tbxNotes.Location = new System.Drawing.Point(8, 240);
			this.tbxNotes.Multiline = true;
			this.tbxNotes.Name = "tbxNotes";
			this.tbxNotes.Size = new System.Drawing.Size(360, 184);
			this.tbxNotes.TabIndex = 2;
			this.tbxNotes.Text = "textBox1";
			// 
			// btnPasteFromClipBoard
			// 
			this.btnPasteFromClipBoard.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.btnPasteFromClipBoard.Location = new System.Drawing.Point(384, 440);
			this.btnPasteFromClipBoard.Name = "btnPasteFromClipBoard";
			this.btnPasteFromClipBoard.Size = new System.Drawing.Size(280, 23);
			this.btnPasteFromClipBoard.TabIndex = 3;
			this.btnPasteFromClipBoard.Text = "Paste image from clipboard";
			this.btnPasteFromClipBoard.Click += new System.EventHandler(this.btnPasteFromClipBoard_Click);
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(672, 470);
			this.Controls.Add(this.btnUpdateDatabase);
			this.Controls.Add(this.btnPasteFromClipBoard);
			this.Controls.Add(this.tbxNotes);
			this.Controls.Add(this.picFish);
			this.Controls.Add(this.grdFishes);
			this.Name = "WinForm";
			this.Text = "The ECO-logical home for tropical fishes";
			((System.ComponentModel.ISupportInitialize)(this.grdFishes)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>

		[STAThread]
		static void Main()
		{
			WinFormDequeuer.Active = true;
			Application.Run(new WinForm());
		}

		private Image ByteArrayWithHeaderToImage(byte[] imageDataWithHeader)
		{
			// the byte array contains a TGraphicsHeader first, so we skip 8 bytes
			// (see DB.pas for details).
			System.IO.Stream imageStream = new System.IO.MemoryStream(
				imageDataWithHeader,
				8,
				imageDataWithHeader.Length-8);

			// create a Bitmap object from the image stream
			Bitmap res = new Bitmap(imageStream);
			return res;
		}

		private void FormatImage(object sender, ConvertEventArgs e)
		{
			// Make sure the preconditions are right
			if (e.DesiredType != typeof(Image)) return ;
			if (e.Value.GetType() != typeof(System.Byte[])) return ;

			try
			{
				e.Value = ByteArrayWithHeaderToImage(e.Value as System.Byte[]);
			}
			catch(Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private byte[] BitmapToByteArrayWithHeader(Bitmap value)
		{
			// convert the image to a byte array
			ImageConverter ic = new ImageConverter();
			System.Byte[] imageData = (System.Byte[])ic.ConvertTo(value, typeof(System.Byte[]));

			// create a second byte array, this time with some extra space for the header
			byte[] imageDataWithHeader = new byte[8 + imageData.Length];
			// Initialize the header. First comes 4 fixed bytes
			imageDataWithHeader[0] = 1;
			imageDataWithHeader[1] = 0;
			imageDataWithHeader[2] = 0;
			imageDataWithHeader[3] = 1;
			// and then comes the length (length of header + image)
			long len = imageData.Length+8;
			int i=4;
			while (len > 0)
			{
				byte remainder = (byte)(len % 256);
				imageDataWithHeader[i] = remainder;
				len = len / 256;
				i++;
			}

			// Copy the image data to the new array
			for (i=0; i<imageData.Length; i++)
				imageDataWithHeader[i+8] = imageData[i];

			return imageDataWithHeader;
		}

		private void ParseImage(object sender, ConvertEventArgs e)
		{
			// Make sure the preconditions are right
			if (e.DesiredType != typeof(System.Byte[])) return;
			if (e.Value.GetType() != typeof(Bitmap)) return;

			try
			{
				e.Value = BitmapToByteArrayWithHeader(e.Value as Bitmap);
			}
			catch(Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
		}

		private void btnPasteFromClipBoard_Click(object sender, System.EventArgs e)
		{
			object clipBoardData = Clipboard.GetDataObject().GetData(DataFormats.Bitmap);
			if (clipBoardData is Bitmap)
			{
				IElement el = CurrencyManagerHandle.CurrentElement(ehAllBioLife, grdFishes);
				BioLife currentFish = el.AsObject as BioLife;

				currentFish.Graphic = BitmapToByteArrayWithHeader(clipBoardData as Bitmap);
			}
			else
				MessageBox.Show("Clipboard does not contain a bitmap image");
		}
	}
}
